#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <pthread.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <signal.h>
#include <stdlib.h>
#include <mysql/mysql.h>
#include <libsql++.h>
#include <libeamon.h>

#include "a.h"
#include "ParserIO.h"
#include "Parser.h"
#include "THREAD.h"
#include "eol.h"


	ADV *advbase = NULL;
	EVENT *eventbase = NULL;
	THREAD *threadbase = NULL;
static	int quit_listen = 0;
static	int quit_main = 0;
	pthread_mutex_t event_mutex;
	pthread_mutex_t thread_mutex;


#define PRINT(x) if (pThread -> write_text(x) == -1) \
		goto crap;

#define INPUT(x) n = 200; \
	if (pThread -> read_text(x, &n) == -1) \
	{ \
		perror("read() failed"); \
		goto crap; \
	}


void *sock_thread(void *zz)
{
	Database db("localhost","root","","eamon");
	Query q(&db);
	THREAD *pThread = (THREAD *)zz;
	FILE *fil;
	int s = pThread -> socket;
	int quit = 0;
	int n;
	int i;
	int menu;
	char slask[200];
	char cmd[200];

	pThread -> cmdline.SetParserIO( pThread );
	pThread -> m_more = 1;
	pThread -> account = NULL;

	while (!pThread -> account)
	{
		PRINT("--------------------------------------------------\n");
		PRINT(" Welcome to The Wonderful World of Eamon *Online*\n");
		PRINT("--------------------------------------------------\n");
		PRINT(" These are the original Eamon Adventures, being\n");
		PRINT(" run on an applesoft basic interpreter for Linux.\n");
		PRINT(" Some special commands extend your stay here:\n");
	        PRINT("  'hi or \"hi         - speak to other players\n");
		PRINT("  /who               - see who's online right now\n");
		PRINT("  /emote <something> - emote is cool\n");
		PRINT("  /abort             - well, sometimes programs hang\n");
		PRINT(" New user? Just enter your preferred login handle\n");
		PRINT(" at the prompt below, and you will be up & away.\n");
		PRINT("--------------------------------------------------\n");
		PRINT("           My email: eamon@alhem.net\n");
		PRINT("--------------------------------------------------\n");
		PRINT("\n");
		PRINT("Login: ");
		pThread -> adjust_case = 1;
		INPUT(cmd) else
		{
			sprintf(slask,"select * from account where login='%s'",cmd);
			pThread -> account = new Account(&db,slask);
			if (!pThread -> account -> num)
			{
				PRINT("Account '%s' does not exist, create (y,N)? ");
				INPUT(slask)
				if (*slask == 'Y')
				{
					PRINT("Enter password: ");
					INPUT(slask)
					strncpy(pThread -> account -> password,slask,20);
					pThread -> account -> password[20] = 0;
					PRINT("Verify password: ");
					INPUT(slask)
					if (!strcmp(slask,pThread -> account -> password))
					{
						strcpy(pThread -> account -> login,cmd);
						pThread -> account -> num_logins = 1;
						pThread -> account -> save();
						sprintf(slask,"update account set created_date=curdate() where num=%ld",pThread -> account -> num);
						q.execute(slask);
					}
					else
					{
						delete pThread -> account;
						pThread -> account = NULL;
					}
				}
				else
				{
					delete pThread -> account;
					pThread -> account = NULL;
				}
			}
			else
			{
				PRINT("Password: ");
				INPUT(slask);
				if (!strcmp(slask,pThread -> account -> password))
				{
					sprintf(slask,"update account set last_login=curdate(),num_logins=num_logins+1 where num=%ld",pThread -> account -> num);
					q.execute(slask);
				}
				else
				{
					delete pThread -> account;
					pThread -> account = NULL;
				}
			}
		}
	}

	sprintf(slask,"%s/%s",EA_ACCTS,pThread -> account -> login);
	if (chdir(slask) == -1)
	{
		perror("chdir() failed");
		if (mkdir(slask, 0755) == -1)
		{
			perror("mkdir() failed");
			PRINT("Failed\n");
			goto crap;
		}
		if (chdir(slask) == -1)
		{
			perror("chdir() failed again");
			PRINT("Failed\n");
			goto crap;
		}
		sprintf(slask,"cp -a %s/ea.master .",EA_DISKS);
		system(slask);
	}

	sprintf(slask,"%s/%s/ea.master",EA_ACCTS,pThread -> account -> login);
	if (chdir(slask) == -1)
	{
		perror("chdir(ea.master) failed");
		PRINT("Failed\n");
		goto crap;
	}

	sprintf(slask, "%s has entered.", pThread -> account -> login);
	pThread -> add_event( slask );

	menu = 1;
	while (!quit)
	{
		PRINT("\n");

		pThread -> adjust_case = 0;

		if (menu)
		{
			sprintf(slask,"*** The Wonderful World of Eamon (Online): %s ***\n",pThread -> account -> login);
			PRINT(slask);
			PRINT(" 1/ Play\n");
			PRINT(" 2/ Display characters\n");
			PRINT(" 3/ Edit (remove) characters\n");
//			PRINT(" 4/ Select adventure\n");
			PRINT(" 5/ Resume adventure\n");
			PRINT(" 6/ Install utility disks\n");
			PRINT(" 7/ BUILD mode (just type HELP after entering)\n");
			PRINT(" 8/ Backup CHARACTERS - BEFORE, not after ;)\n");
			PRINT(" 9/ Restore backup\n");
			PRINT(" 0/ Quit\n");
			menu = 0;
		}
		PRINT("1-9,0,?> ");

		INPUT(slask)
		if (!*slask)
			strcpy(slask,"7");
		switch (atoi(slask))
		{
		case 1:
			pThread -> cmdline.finish();
			pThread -> adjust_case = 1;
			strcpy(cmd,"RUN HELLO");
			pThread -> cmdline.cmd(cmd);
			pThread -> cmdline.finish();
			menu = 1;
			break;
		case 2:
			pThread -> cmdline.finish();
			pThread -> adjust_case = 1;
			strcpy(cmd,"RUN DISPLAY CHARACTERS");
			pThread -> cmdline.cmd(cmd);
			pThread -> cmdline.finish();
			menu = 1;
			break;
		case 3:
			pThread -> cmdline.finish();
			pThread -> adjust_case = 1;
			strcpy(cmd,"RUN EDIT CHARACTERS");
			pThread -> cmdline.cmd(cmd);
			pThread -> cmdline.finish();
			menu = 1;
			break;
		case 4:
			if (pThread -> get_adv() == -1)
				goto crap;
			break;
		case 5:
			if (pThread -> selected)
			{
				sprintf(slask,"../%s",pThread -> selected -> dir);
				if (chdir(slask) == -1)
					perror("chdir() failed");
			}
			if ((fil = fopen("EAMON.NAME","rb")) != NULL)
			{
				unsigned char c;

				i = 0;
				fread(&c,1,1,fil);
				while (!feof(fil) && c && c != 0x8d)
				{
					slask[i++] = c & 0x7f;
					fread(&c,1,1,fil);
				}
				fclose(fil);
				slask[i] = 0;

				PRINT("Resuming adventure '");
				PRINT( slask );
				PRINT("'\n");

				pThread -> cmdline.finish();
				pThread -> adjust_case = 1;
				sprintf(cmd,"RUN %s",slask);
				pThread -> cmdline.cmd( cmd );
				pThread -> cmdline.finish();
				menu = 1;
			}
			else
			{
				chdir("../ea.master");
			}
			break;
		case 6:
			sprintf(slask,"cp -a %s/* %s/%s",EA_UTILS,EA_ACCTS,pThread -> account -> login);
			system(slask);
			PRINT("Ok.\n");
			break;
		case 7:
			PRINT("Just type HELP\n");
			pThread -> cmdline.m_current_line = pThread -> cmdline.m_linebase;
			while (1)
			{
				PRINT("\n>");
				INPUT( slask )
				if (!strncasecmp(slask,"quit",4) || !*slask)
					break;
				else
					pThread -> cmdline.cmd( slask );
			}
			break;
		case 8:
			system("cp CHARACTERS CHARACTERS.BACKUP");
			break;
		case 9:
			system("cp CHARACTERS.BACKUP CHARACTERS");
			break;

		default:
			if (*slask == '0')
			{
				sprintf(slask,"%s has left.",pThread -> account -> login);
				pThread -> add_event(slask);
				quit++;
			}
			else
			if (*slask == '?')
				menu = 1;
		}
	}
crap:
	close(s);
	delete pThread -> account;
	pThread -> account = NULL;
	pThread -> running = 0;
	return zz;
}

void *listen_thread(void *zz)
{
	THREAD *t;
	THREAD *prev;
	FILE *fil;
	void *retval;
	struct sockaddr_in sa;
	socklen_t len;
	struct timeval tv;
	fd_set rfds;
	long l = 0;
	int s = socket(AF_INET, SOCK_STREAM, 0);
	int a_s;
	int optval;
	int n;

	sa.sin_family = AF_INET; // hp -> h_addrtype;
	sa.sin_port = htons(4444);
//	sa.sin_addr.s_addr = 0;
	memmove(&sa.sin_addr,&l,4);
//	sa.sin_zero[0] = 0;
//	sa.sin_zero[1] = 0;
//	sa.sin_zero[2] = 0;
//	sa.sin_zero[3] = 0;
//	sa.sin_zero[4] = 0;
//	sa.sin_zero[5] = 0;
//	sa.sin_zero[6] = 0;
//	sa.sin_zero[7] = 0;

	if (s == -1)
	{
		perror("socket() failed");
		exit(-1);
	}
	optval = 1;
	if (setsockopt(s, SOL_SOCKET, SO_REUSEADDR, (void *)&optval, sizeof(optval)) == -1)
	{
		perror("setsockopt() failed");
		exit(-1);
	}
	optval = 1;
	if (setsockopt(s, SOL_SOCKET, SO_KEEPALIVE, (void *)&optval, sizeof(optval)) == -1)
	{
		perror("setsockopt() failed");
		exit(-1);
	}
	if (bind(s, (struct sockaddr *)&sa, sizeof(sa)) == -1)
	{
		perror("bind() failed");
		exit(-1);
	}
	if (listen(s, 3) == -1)
	{
		perror("listen() failed");
		exit(-1);
	}
	
	while (!quit_listen)
	{
		FD_ZERO(&rfds);
		FD_SET(s, &rfds);

		tv.tv_sec = 1;
		tv.tv_usec = 0;
		n = select(s + 1, &rfds, NULL, NULL, &tv);
		if (n == -1)
		{
			perror("select() failed");
		} else
		if (n > 0)
		{
			if (FD_ISSET(s, &rfds))
			{
				a_s = accept(s, (struct sockaddr *)&sa, &len);
				if (a_s == -1)
				{
					perror("accept() failed");
				}
				else
				{
					fil = fopen("sa_log.bin","ab");
					fwrite(&len,1,sizeof(len),fil);
					fwrite(&sa,1,len,fil);
					fclose(fil);
	for (int i = 0; i < (int)len; i++)
	{
		if (i)
			printf(".");
		printf("%d",((unsigned char *)&sa)[i]);
	}
	printf("\n");
					t = new THREAD;
					t -> socket = a_s;
					t -> running = 1;
					pthread_mutex_lock(&thread_mutex);
					t -> next = threadbase;
					threadbase = t;
					pthread_mutex_unlock(&thread_mutex);
					if (pthread_create(&t -> thread, NULL, sock_thread, t))
					{
						printf("Couldn't create socket thread\n");
						exit(-1);
					}
				}
			}
		} // if (n > 0)
		pthread_mutex_lock(&thread_mutex);
		do
		{
			prev = NULL;
			for (t = threadbase; t; t = t -> next)
				if (!t -> running)
				{
					if (pthread_join(t -> thread,&retval))
					{
						printf("pthread_join failed\n");
					}
					if (!prev)
						threadbase = t -> next;
					else
						prev -> next = t -> next;
					delete t;
					printf("sock_thread() removed\n");
					break;
				}
				else
				{
					prev = t;
				}
		} while (t);
		pthread_mutex_unlock(&thread_mutex);
	}
	close(s);
	printf("Listen loop end\n");
	for (t = threadbase; t; t = t -> next)
	{
		t -> running = 0;
		if (pthread_join(t -> thread,&zz))
		{
			printf("pthread_join() failed: socket thread\n");
		}
	}
	pthread_mutex_lock(&thread_mutex);
	for (t = threadbase; t; t = prev)
	{
		prev = t -> next;
		delete t;
	}
	pthread_mutex_unlock(&thread_mutex);
	return zz;
}

void sighandler(int sig)
{
	printf("Signal: %d\n",sig);
	quit_main = 1;
	quit_listen = 1;
}

void sigpipe(int sig)
{
}

void strzcpy(char *slask,char *s)
{
	strcpy(slask,s ? s : "");
	while (strlen(slask) && slask[strlen(slask) - 1] == ' ')
		slask[strlen(slask) - 1] = 0;
}

void read_games(void)
{
	FILE *fil;
	ADV *adv;
	ADV *q;
	char *s;
	char descr[200];
	char slask[200];
	char dirname[200];

	if ((fil = fopen(EA_GAMES,"rt")) != NULL)
	{
		fgets(slask,200,fil);
		while (!feof(fil))
		{
			slask[strlen(slask) - 1] = 0;
			adv = new ADV;
			s = strtok(slask,";");
			strzcpy(descr,s);
			s = strtok(NULL, ";");
			strzcpy(adv -> author,s);
			s = strtok(NULL, ";");
			strzcpy(adv -> rating,s);
			s = strtok(NULL, ";");
			strzcpy(adv -> flags,s);
			s = strtok(NULL, ";");
			strzcpy(dirname,s);
			if (*dirname)
			{
				adv -> next = NULL;
				descr[3] = 0;
				adv -> num = atoi(descr);
				strcpy(adv -> descr,descr + 5);
				strcpy(adv -> dir,dirname);
				if (!advbase)
					advbase = adv;
				else
				{
					q = advbase;
					while (q -> next)
						q = q -> next;
					q -> next = adv;
				}
				printf("%d: '%s' by '%s' rating '%s'\n",
					adv -> num,
					adv -> descr,
					adv -> author,
					adv -> rating);
			}
			else
			{
				delete adv;
			}
			fgets(slask,200,fil);
		}
		fclose(fil);
	}
}

int main(int argc,char *argv[])
{
	void *zz;
	pthread_t listen_t;

	signal(SIGINT, sighandler);
	signal(SIGPIPE, sigpipe);

	read_games();

	eventbase = new EVENT;
	eventbase -> next = NULL;
	strcpy(eventbase -> text,"Startup.");

	pthread_mutex_init(&event_mutex, NULL);
	pthread_mutex_init(&thread_mutex, NULL);

	if (pthread_create(&listen_t, NULL, listen_thread, NULL))
	{
		printf("Couldn't create listen thread\n");
		exit(-1);
	}
	while (!quit_main)
	{
		sleep(1);
	}
	printf("Main loop end\n");
	if (pthread_join(listen_t,&zz))
	{
		printf("listen thread pthread_join() failed\n");
	}
	return 0;
}

